/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class FspHmcLockStatus {
    private static final String GET_HMC_LOCK_STATUS = "GET_HMC_LOCK_STATUS";
    private static final String NUM_FSP_SUPPORTED_LOCKSTAT_BYTES = "NUM_FSP_SUPPORTED_LOCKSTAT_BYTES";
    private static final String NUM_LOCKSTAT_BYTES = "NUM_LOCKSTAT_BYTES";
    private static final String LOCKSTAT_BYTES = "LOCKSTAT_BYTES";
    private UnsignedInt16 mNumFspSupportedLockstatBytes;
    private UnsignedInt16 mNumLockstatBytesReturned;
    private UnsignedInt16 mFirstLockstatByteRequested;
    private UnsignedInt16 mNumLockstatBytesRequested;
    private UnsignedInt16 mPersistenceFlags;
    private UnsignedInt16 mHmcIdLength;
    private UnsignedInt8[] mTheLockstatBytes;
    private String mHmcId;
    private UnsignedInt32 mToolType;
    private static FspHmcLockStatus mInst;

    public FspHmcLockStatus() {
    }

    public FspHmcLockStatus(UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt16 unsignedInt163, UnsignedInt32 unsignedInt32, String string) {
        this.setFirstByteRequested(unsignedInt16);
        this.setNumLockstatBytesRequested(unsignedInt162);
        this.setPersistenceFlags(unsignedInt163);
        this.setToolType(unsignedInt32);
        this.setHmcId(string);
        this.setHmcIdLength();
    }

    static FspHmcLockStatus getInstance() {
        if (mInst == null) {
            mInst = new FspHmcLockStatus();
        }
        return mInst;
    }

    public FspHmcLockStatus getHmcLockStatusCmd(FSPCmdMgr fSPCmdMgr, FspHmcLockStatus fspHmcLockStatus) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        hashtable = fSPCmdMgr.doFSPCommand(GET_HMC_LOCK_STATUS, new String[]{fspHmcLockStatus.getFirstByteRequested().toString(), fspHmcLockStatus.getNumLockstatBytesRequested().toString(), fspHmcLockStatus.getPersistenceFlags().toString(), fspHmcLockStatus.getToolType().toString(), fspHmcLockStatus.getHmcIdLength().toString(), fspHmcLockStatus.getHmcId()});
        this.setNumFspSupportedLockstatBytes((UnsignedInt16)hashtable.get(NUM_FSP_SUPPORTED_LOCKSTAT_BYTES));
        this.setNumLockstatBytesReturned((UnsignedInt16)hashtable.get(NUM_LOCKSTAT_BYTES));
        UnsignedInt8[] unsignedInt8Array = (UnsignedInt8[])hashtable.get(LOCKSTAT_BYTES);
        this.setTheLockstatBytes(unsignedInt8Array);
        return this;
    }

    public void setToolType(UnsignedInt32 unsignedInt32) {
        this.mToolType = unsignedInt32;
    }

    public UnsignedInt32 getToolType() {
        return this.mToolType;
    }

    public void setHmcId(String string) {
        System.out.println("HmcIdString before null padding = " + string);
        this.mHmcId = ByteUtilities.toHexString(FspHmcLockStatus.javaToFSPString(string));
        System.out.println("HmcIdString after null padding = " + this.mHmcId);
    }

    public String getHmcId() {
        return this.mHmcId;
    }

    public void setHmcIdLength() {
        this.mHmcIdLength = this.mHmcId != null ? new UnsignedInt16(this.mHmcId.length()) : null;
    }

    public UnsignedInt16 getHmcIdLength() {
        return this.mHmcIdLength;
    }

    public void setFirstByteRequested(UnsignedInt16 unsignedInt16) {
        this.mFirstLockstatByteRequested = unsignedInt16;
    }

    public UnsignedInt16 getFirstByteRequested() {
        return this.mFirstLockstatByteRequested;
    }

    public void setNumLockstatBytesRequested(UnsignedInt16 unsignedInt16) {
        this.mFirstLockstatByteRequested = unsignedInt16;
    }

    public UnsignedInt16 getNumLockstatBytesRequested() {
        return this.mNumLockstatBytesRequested;
    }

    public void setPersistenceFlags(UnsignedInt16 unsignedInt16) {
        this.mPersistenceFlags = unsignedInt16;
    }

    public UnsignedInt16 getPersistenceFlags() {
        return this.mPersistenceFlags;
    }

    public void setNumFspSupportedLockstatBytes(UnsignedInt16 unsignedInt16) {
        this.mNumFspSupportedLockstatBytes = unsignedInt16;
    }

    public UnsignedInt16 getNumFspSupportedLockstatBytes() {
        return this.mNumFspSupportedLockstatBytes;
    }

    public void setNumLockstatBytesReturned(UnsignedInt16 unsignedInt16) {
        this.mNumLockstatBytesReturned = unsignedInt16;
    }

    public UnsignedInt16 getNumLockstatBytesReturned() {
        return this.mNumLockstatBytesReturned;
    }

    public void setTheLockstatBytes(UnsignedInt8[] unsignedInt8Array) {
        for (int i = 0; i < unsignedInt8Array.length; ++i) {
            this.mTheLockstatBytes[i] = unsignedInt8Array[i];
        }
    }

    public UnsignedInt8[] getTheLockstatBytes() {
        return this.mTheLockstatBytes;
    }

    private static final byte[] javaToFSPString(String string) {
        byte[] byArray = null;
        int n = 2 + string.length();
        n += 4 - n % 4;
        byArray = new byte[n];
        byArray[0] = (byte)(n - 2 >> 8 & 0xFF);
        byArray[1] = (byte)(n - 2 & 0xFF);
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
        System.arraycopy(byArray2, 0, byArray, 2, string.length());
        return byArray;
    }
}

